/*
 * Effekt Start Dauer   Kommentar
 *   1    z20   7.0..
 *   2    z21   
 *   3.   z22
 *
 *
 *
 *
 */
#include <sstream>

#include "camera.h"
#include "camerapath.h"
#include "cube.h"
#include "light.h"
#include "main.h"

#include "data.h"

#include <color.hpp>
#include <functions.hpp>
#include <rand.hpp>
#include <vektor.hpp>
using namespace doj;

namespace Anfang
{
  static long   starttime = 0L;
  static bool   initialized = false;
  static const  float scene_maxtime = 5.0; // 5 seconds for that scene
  static float  yscale = 1.0;
  static float  xscale = 1.0;
  const  float  zlinespeed = 2.0; // speed for the four lines from the edges of the square to the audience.
  const  int    cubeDepth = 9; // draw 2^9 cubes



  static Camera       cam;

  static Light       *light = NULL;

  static CameraPath   campath;
  static bool         pathInitialized = false;
  static int          sync=0;

  static Cube        *cube = NULL;
  static Cube        *cube2 = NULL;

  static void drawEffekt1(const int time);
  static bool effekt1Init=false;

  static void drawEffekt2(const int time);
  static bool  effekt2Init=false;

  static void drawEffekt3(const int time);
  static bool  effekt3Init=false;


  /*
   *
   */
  static inline void  POINT3D(float x, float y, float z)
  {
    glVertex3f(xscale*(x*2.0-1.0), yscale*(y*2.0-1.0),z);
  }

  /*
   *
   */
  static inline void LINE3D(float x1,float y1,float z1, float x2, float y2,float z2)
  {
    POINT3D(x1,y1,z1);
    POINT3D(x2,y2,z2);
  }

  /*
   *
   */
  static inline void LINE2D(float x1, float y1, float x2, float y2)
  {
    glVertex2f(xscale*(x1*2.0-1.0), yscale*(y1*2.0-1.0));
    glVertex2f(xscale*(x2*2.0-1.0), yscale*(y2*2.0-1.0));
  }


  /*
   *
   */
  void positionCube (float dt, float maxdt, int id, int depth)
  {
    if (depth >= maxdt)
      return;

    if (dt > (float)(depth+1))
      positionCube(dt, maxdt, id>>1, depth+1);
    float tt = dt - (float)depth;
    float t = (tt>1.0)?1.0:tt;
    float zoom = (float)(2*intpow(2, (depth/3)));
    int   d = depth%3;
    if (id&1)
      glRotatef(180.0*t, (d==1)?1:0, (d==2)?1:0, (d==0)?1:0);
    glTranslatef( (d==0)?(zoom*t):0,
		  (d==1)?(zoom*t):0,
		  (d==2)?(-zoom*t):0 );
  }

  /*
   *
   */
  void positionCube(float dt, int index, float maxdt=3.0)
  {
    positionCube(dt, maxdt, index, 0);
  }


  int init ()
  {
    starttime = 0L;
    initialized = false;
    pathInitialized = false;
    effekt1Init=false;
    effekt2Init=false;
    effekt3Init=false;


    light = new Light("Anfang::Effek2::Light");
    if (light)
      {
	light->pos.x = 25;
	light->pos.y = 50;
	light->pos.z = 100;
	light->setLight(0);
	light->init();
      }


    std::istringstream camPathFile(reinterpret_cast<char*>(&PTHanfang));
    if (camPathFile)
      camPathFile >> campath;
    campath.init();

    /*-- wireframe cube --*/
    cube = new Cube("Anfang::Cube1");
    if (cube)
      {
	cube->color(1.0,1.0,1.0);
	cube->init(false, true);
      }

    /*-- solid cube --*/
    cube2 = new Cube("Anfang::Cube2");
    if(cube2==NULL)
      {
	cerr << __FILE__ << "::init(): could not alloc cube" << endl;
	return -1;
      }
    hsv h(0, 74.0/256.0, 150.0/256.0);
    rgba r;
    r=h;
    cube2->color(r.r, r.g, r.b);
    cube2->colorLight(r.r, r.g, r.b, 1.0, ColorObject::Diffuse);
    rgba r2=r;
    r2*=0.8;
    cube2->colorLight(r2.r, r2.g, r2.b, 1.0, ColorObject::Ambient);
    r2=r;
    r2*=1.2;
    cube2->colorLight(r2.r, r2.g, r2.b, 1.0, ColorObject::Specular);
    cube2->setLight(light->num);
    if(cube2->init() < 0)
      {
	cerr << "Anfang::could not init cube2" << endl;
	delete cube2;
	cube2=0;
	return -1;
      }

    return 0;
  }



  /*
   *================================   D R A W   ===================================
   */
  void draw (const int time)
  {
    if (!initialized)
      {
	starttime = time;
	initialized = true;
      }

    /*
     * z20 = 1.Effekt z21=2.Effekt
     */

    for(modSync_t::iterator i=modSync.begin(); i!=modSync.end(); /*nothing here*/)
      {
	const int e=*i>>4;
	if(e==2 || e==4)
	  {
	    sync=*i&0xf;
	    i=modSync.erase(i);
	  }
	else
	  ++i;
      }


    if (sync==0)
      {
	if (!effekt1Init)
	  {
	    starttime=time;
	    effekt1Init=true;
	  }
	sync=-1;
      }
    else if (sync==1)
      {
	if (!effekt2Init)
	  {
	    starttime=time;
	    effekt2Init=true;
	  }
	sync=-1;
      }
    else if (sync==2)
      {
	if (!effekt3Init)
	  {
	    starttime=time;
	    effekt3Init=true;
	  }
	sync=-1;
      }


    if (effekt1Init && !effekt2Init)
      drawEffekt1(time);

    if (effekt2Init && !effekt3Init)
      drawEffekt2(time);

    if (effekt3Init)
      drawEffekt3(time);
  }




  /*
   *
   */
  static void drawEffekt1(const int time)
  {
    float dt = (float)(time-starttime)/1000.0;

    //    const float  x0=-2.0;
    const float  x1=0.0;
    const float  x2=1.0;
    const float  y1=1.0;
    const float  y2=0.0;

    glLoadIdentity();
    glDisable(GL_DEPTH_TEST);

    cam.x=cam.y=0;
    cam.z=1;
    activeCamera = &cam;
    cam.position();

    clearColor.r=clearColor.g=clearColor.b=clearColor.a=0;

    glTranslatef(0.0,0.0,-1.0);

    glBegin(GL_LINES);
    glColor3f(1.0,1.0,1.0);
    
    float len = 2.0*((x2-x1)+(y1-y2));

    if (dt > 2.0) /* section 1 - rechte linie */
      {
	const float sec1 = (y1-y2)*(dt-2.0);
	const float y = ((y2+sec1)>y1)?y1:(y2+sec1);
	LINE2D(x2,y2, x2,y);
	len -= (dt>=3.0)?(y1-y2):sec1;
      }
    
    if (dt > 3.0) /* section 2 - obere linie */
      {
	const float sec2 = (x2-x1)*(dt-3.0);
	const float x = ((x2-sec2)<x1)?x1:(x2-sec2);
	LINE2D(x,y1, x2,y1);
	len -= (dt>=4.0)?(x2-x1):sec2;
      }
    
    if (dt > 4.0) /* section 3 - linke linie */
      {
	const float sec3 = (y1-y2)*(dt-4.0);
	const float y = ((y1-sec3)<y2)?y2:(y1-sec3);
	LINE2D(x1,y1, x1,y);
	len -= (dt>=5.0)?(y1-y2):sec3;
      }
    
    /* section 0 - untere Linie */
    if (len<0.0)
      len=0.0;
    //      const float sec0 = (x2-x1)*dt;
    const float sec0 = (x2-x1)*(dt-1.0);
    LINE2D(x2-len,y2, ((x1+sec0)>x2)?x2:(x1+sec0),y2);


    /*-------- The four lines to the screen -----------*/	
    if (dt > 5.0)
      LINE3D(x1,y2,0.0, x1,y2, zlinespeed*(dt-5.0));
    if (dt > 5.5)
      LINE3D(x1,y1,0.0, x1,y1, zlinespeed*(dt-5.5));
    if (dt > 6.0)
      LINE3D(x2,y1,0.0, x2,y1, zlinespeed*(dt-6.0));
    if (dt > 6.5)
      LINE3D(x2,y2,0.0, x2,y2, zlinespeed*(dt-6.5));

    /* 7.0 = ENDE noch 0.43 Sekunden bist zum naechsten 2. Effekt */

    glEnd();

    glEnable(GL_DEPTH_TEST);
  }



  /*
   *
   */
  static void drawEffekt2(const int time)
  {
    float dt = (float)(time-starttime)/1000.0;
    
    if (!pathInitialized)
      {
	pathInitialized=true;
	campath.starttime(time);
      }

#if 0
    activeCamera = &cam;
    cam.position();
#else
    campath.position(time);
#endif


    if ((dt>=0.0) && (dt<1.0))
      dt=0.0;  // 1 sekunde lang keine Aktion nur Kamerazoom
    else
      dt -= 1.0; // nach einer sekunde beginnt der Effekt bei 0.0 sekunden (1.0-1.0)

    cube->before();
    const int n = intpow(2,cubeDepth);
    for (int i=0; i<n; i++)
      {
	glPushMatrix();
	positionCube(dt, i, cubeDepth);
	cube->draw();
	glPopMatrix();
      }
    cube->after();
  }




  /*
   *
   */
  static void drawEffekt3(const int time)
  {
    float dt = (float)(time-starttime)/1000.0;

#if 0
    if (dt > 10.0)
      {
	activeCamera = &cam;
	cam.position();
      }
    else
#endif
      {
	campath.position(time);
	cam = campath(time);
      }

    //    if (dt>6.0) dt=6.0;
    //    dt *= 2.0;
    const float threshhold = dt/10.0;

    float sf = 1.0+((dt/10.0));
    if (sf>2.0)
      sf=2.0;


    glPushMatrix();

    light->draw();

    const float scaletime=dt/10.0;
    float zf = (15.0/16.0) * (scaletime-1.0)*(scaletime-1.0) + (1.0/16.0); // quadratisch
    if (scaletime>1.0)
      zf = 0.0625;
    glScalef(zf,zf,zf);
    
    for (int yi=-7; yi<=7; yi+=2)
      {
	for (int xi=-7; xi<=7; xi+=2)
	  {
	    for (int zi=-7; zi<=7; zi+=2)
	      {
		glPushMatrix();
		glTranslatef (2*xi,2*yi,2*zi);
		glScalef(sf,sf,sf);
		if (
		    ( ((float)(xi+7)/14.0) +
		      ((float)(yi+7)/14.0) +
		      ((float)(zi+7)/14.0) ) / 3.0

		    <  threshhold )

		  cube2->drawSingle();
		else
		  cube->drawSingle();
		glPopMatrix();
	      }
	  }
      }
    glPopMatrix();
  }



  /*
   *
   */
  void cleanup ()
  {
    if(light)
      delete light;
    if(cube)
      delete cube;
    if(cube2)
      delete cube2;
  }

};
