#include <iostream>

using namespace std;

#include "camera.h"
#include "main.h"

bool Camera::left=false, Camera::right=false;

Camera::Camera()
{ 
  reset();
}

void Camera::position()
{
  static float lastFov=0;
  static float lastNC=0;
  static float lastFC=0;
  static int lastWidth=0;
  static int lastHeight=0;

  if(fov!=lastFov
     || nearClip!=lastNC
     || farClip!=lastFC
     || screen.width!=lastWidth
     || screen.height!=lastHeight
     )
    {
      glMatrixMode(GL_PROJECTION);
      glLoadIdentity();
      gluPerspective(fov, (float)screen.width/(float)screen.height, nearClip, farClip);
      lastFov=fov;
      lastNC=nearClip;
      lastFC=farClip;
      lastWidth=screen.width;
      lastHeight=screen.height;
    }

  // eye distance
  float offset=(left?-1:0)+(right?+1:0);
  offset*=.05;

  glMatrixMode(GL_MODELVIEW);
  glRotatef(offset, 0, 1, 0);	// fake rotation of camera to compensate eye distance
  glTranslatef(-x+offset, -y, -z);
  glRotatef(head, 1, 0, 0);
  glRotatef(pitch, 0, 1, 0);
  glRotatef(roll, 0, 0, 1);
}

void Camera::reset()
{
  x=0.0;
  y=0.0;
  z=3;
  roll=0.0;
  pitch=0.0;
  head=0.0;
  fov=90.0;
  nearClip=1;
  farClip=100;
}

Camera& Camera::operator+=(const Camera& c)
{
  x+=c.x;
  y+=c.y;
  z+=c.z;
  roll+=c.roll;
  pitch+=c.pitch;
  head+=c.head;
  fov+=c.fov;
  nearClip+=c.nearClip;
  farClip+=c.farClip;
  return *this;
}

Camera& Camera::operator-=(const Camera& c)
{
  x-=c.x;
  y-=c.y;
  z-=c.z;
  roll-=c.roll;
  pitch-=c.pitch;
  head-=c.head;
  fov-=c.fov;
  nearClip-=c.nearClip;
  farClip-=c.farClip;
  return *this;
}

Camera& Camera::operator*=(const float& f)
{
  x*=f;
  y*=f;
  z*=f;
  roll*=f;
  pitch*=f;
  head*=f;
  fov*=f;
  nearClip*=f;
  farClip*=f;
  return *this;
}

ostream& Camera::print(ostream& os) const
{
  os << x << " ";
  os << y << " ";
  os << z << " ";
  os << roll << " ";
  os << pitch << " ";
  os << head << " ";
  os << fov << " ";
  os << nearClip << " ";
  os << farClip << " ";
  return os << endl;
}

istream& Camera::scan(istream& is)
{
  is >> x;
  is >> y;
  is >> z;
  is >> roll;
  is >> pitch;
  is >> head;
  is >> fov;
  is >> nearClip;
  is >> farClip;
  return is;
}
