#ifndef CAMERA__H
#define CAMERA__H

#include <iostream>

using namespace std;

class Camera
{
public:
  static bool left, right;	/* look with left or right eye ? */

  float x;
  float y;
  float z;
  float roll;
  float pitch;
  float head;
  float fov;
  float nearClip;
  float farClip;

  Camera();
  void position();
  void reset();

  Camera& operator+=(const Camera&);
  Camera& operator-=(const Camera&);
  Camera& operator*=(const float&);

  ostream& print(ostream&) const;
  istream& scan(istream&);
};

inline Camera operator*(const Camera& c, const float& f)
{
  return Camera(c)*=f;
}

inline Camera operator+(const Camera& l, const Camera& r)
{
  return Camera(l)+=r;
}

inline Camera operator-(const Camera& l, const Camera& r)
{
  return Camera(l)-=r;
}

inline ostream& operator<<(ostream& os, const Camera& c)
{
  return c.print(os);
}

inline istream& operator>>(istream& is, Camera& c)
{
  return c.scan(is);
}

#endif
