#include "camerapath.h"

ostream& CameraPath::print(ostream& os) const
{
  os << name_ << endl;
  os << starttime_ << endl;
  os << runtime_ << endl;
  for(Bezier_t::const_iterator i=bezier_.container().begin(); i!=bezier_.container().end(); ++i)
    os << *i;
  return os;
}

istream& CameraPath::scan(istream& is)
{
#if _WIN32 // oh, shitty vc, can do nothing!
  char buf[100];
  is.getline(buf, 100);
  name_=buf;
#else
  is >> name_;
#endif
  is >> starttime_;
  is >> runtime_;
  while(is)
    {
      Camera c;
      is >> c;
      if(is)
	push_back(c);
    }
  return is;
}

ostream& operator<<(ostream& os, const CameraPath& c)
{
  return c.print(os);
}

istream& operator>>(istream& is, CameraPath& c)
{
  return c.scan(is);
}
