#ifndef CAMERAPATH__H
#define CAMERAPATH__H

#include "camera.h"
#include "doj/bezier.hpp"
using namespace doj;

#include <string>
using namespace std;

class CameraPath
{
 protected:
  typedef Bezier<Camera> Bezier_t;

  string name_;
  Bezier_t bezier_;
  int starttime_;
  float runtime_;

 public:
  CameraPath(const string& n="unknownCameraPath") :
    name_(n),
    starttime_(-1),
    runtime_(1)
    {
      if(name_.empty())
	name_="unknownCameraPath";
    }

  void init() { bezier_.init(); }

  void starttime(const int t) { starttime_=t; }
  void runtime(const float f) { runtime_=f; }
  const float runtime() { return runtime_; }
  Camera operator()(const int t) { return bezier_((t-starttime_)/1000.0/runtime_); }
  void position(const int t) { operator()(t).position(); }

  void push_back(const Camera& c) { bezier_.container().push_back(c); }
  Camera& operator[](const int i) { return bezier_[i]; }

  ostream& print(ostream&) const;
  istream& scan(istream&);
};

ostream& operator<<(ostream&, const CameraPath&);
istream& operator>>(istream&, CameraPath&);

#endif
