#include "cube.h"

const bool Cube::Solid=true;
const bool Cube::Wire=false;

Cube::Cube(const string& n) :
  ColorObject(n)
{
}

int Cube::init()
{
  return init(true, false);
}

int Cube::init(const bool solid, const bool wire)
{
  flatEnable=true;

  const float coord[8][3] =
    {
      {-1,-1,+1},
      {+1,-1,+1},
      {+1,+1,+1},
      {-1,+1,+1},
      {-1,-1,-1},
      {+1,-1,-1},
      {+1,+1,-1},
      {-1,+1,-1},
    };

  listID=glGenLists(1);
  if(listID==0)
    {
      e("could not generate a list for cube");
      return -1;
    }

  glPushMatrix();
  glLoadIdentity();
  glNewList(listID, GL_COMPILE);
  setMaterial();
  glBindTexture(GL_TEXTURE_2D, textureID);

  if(solid)
    {
      glBegin(GL_QUADS);
      {
	glColor4f(r, g, b, a);
	if(outside)
	  {
	    // front
	    glNormal3f(0,0,+1);
	    glTexCoord2f( 1, 0); glVertex3fv(coord[0]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[1]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[2]);
	    glTexCoord2f( 1, 1); glVertex3fv(coord[3]);
				 
	    // left		 
	    glNormal3f(-1,0,0);	 
	    glTexCoord2f( 1, 0); glVertex3fv(coord[4]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[0]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[3]);
	    glTexCoord2f( 1, 1); glVertex3fv(coord[7]);
				 
	    // back		 
	    glNormal3f(0,0,-1);	 
	    glTexCoord2f( 1, 0); glVertex3fv(coord[5]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[4]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[7]);
	    glTexCoord2f( 1, 1); glVertex3fv(coord[6]);
				 
	    // right		 
	    glNormal3f(+1,0,0);	 
	    glTexCoord2f( 1, 0); glVertex3fv(coord[1]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[5]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[6]);
	    glTexCoord2f( 1, 1); glVertex3fv(coord[2]);
				 
	    // top		 
	    glNormal3f(0,+1,0);	 
	    glTexCoord2f( 1, 0); glVertex3fv(coord[3]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[2]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[6]);
	    glTexCoord2f( 1, 1); glVertex3fv(coord[7]);
				 
	    // bot		 
	    glNormal3f(0,-1,0);	 
	    glTexCoord2f( 1, 0); glVertex3fv(coord[4]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[5]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[1]);
	    glTexCoord2f( 1, 1); glVertex3fv(coord[0]);
	  }			 
	else			 
	  {			 
	    // front		 
	    glNormal3f(0,0,-1);	 
	    glTexCoord2f( 1, 1); glVertex3fv(coord[3]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[2]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[1]);
	    glTexCoord2f( 1, 0); glVertex3fv(coord[0]);
				 
	    // left		 
	    glNormal3f(+1,0,0);	 
	    glTexCoord2f( 1, 1); glVertex3fv(coord[7]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[3]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[0]);
	    glTexCoord2f( 1, 0); glVertex3fv(coord[4]);
				 
	    // back		 
	    glNormal3f(0,0,+1);	 
	    glTexCoord2f( 1, 1); glVertex3fv(coord[6]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[7]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[4]);
	    glTexCoord2f( 1, 0); glVertex3fv(coord[5]);
				 
	    // right		 
	    glNormal3f(-1,0,0);	 
	    glTexCoord2f( 1, 1); glVertex3fv(coord[2]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[6]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[5]);
	    glTexCoord2f( 1, 0); glVertex3fv(coord[1]);
				 
	    // top		 
	    glNormal3f(0,-1,0);	 
	    glTexCoord2f( 1, 1); glVertex3fv(coord[7]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[6]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[2]);
	    glTexCoord2f( 1, 0); glVertex3fv(coord[3]);
				 
	    // bot		 
	    glNormal3f(0,+1,0);	 
	    glTexCoord2f( 1, 1); glVertex3fv(coord[0]);
	    glTexCoord2f( 0, 1); glVertex3fv(coord[1]);
	    glTexCoord2f( 0, 0); glVertex3fv(coord[5]);
	    glTexCoord2f( 1, 0); glVertex3fv(coord[4]);
	  }
      }
      glEnd();
    }

  if(wire)
    {
      glScalef(1.00001, 1.00001, 1.00001);

      glBegin(GL_LINE_STRIP);
      glColor4f(r, g, b, a);
      glVertex3fv(coord[0]);
      glVertex3fv(coord[1]);
      glVertex3fv(coord[2]);
      glVertex3fv(coord[3]);
      glVertex3fv(coord[0]);
      glVertex3fv(coord[4]);
      glVertex3fv(coord[5]);
      glVertex3fv(coord[6]);
      glVertex3fv(coord[7]);
      glVertex3fv(coord[3]);
      glEnd();

      glBegin(GL_LINES);
      glColor4f(r, g, b, a);
      glVertex3fv(coord[1]);
      glVertex3fv(coord[5]);
      
      glVertex3fv(coord[2]);
      glVertex3fv(coord[6]);
      
      glVertex3fv(coord[4]);
      glVertex3fv(coord[7]);
      glEnd();
    }

  glEndList();
  glPopMatrix();
  return 0;
}
