#!/usr/bin/perl

my $filename=$ARGV[0];
die "$filename not found" unless -f $filename;

my $asmprefix=$ARGV[1];

# be sure we are exclusivly running
if($ENV{TERM})
{
    open(LOCK, ">>perl.lck") or die "could not open perl.lck";
    flock(LOCK, LOCK_EX);
}

# generate the asm file
$filename=~m{([^/.]+)\.([^.]+)$};
my $file=$1;
my $ext=$2;
$file=~s/[^\w\d]/_/g;
$file=uc($ext).$file;
open(A, ">$filename.asm") or die "could not open $filename.asm";
print A "section .data\n";
print A "global $asmprefix$file\n";
print A "$asmprefix$file: incbin \"$filename\"\n";
print A "        db 0\n"; # end of string marker
close(A);

# and include in data.h

# create file if not existing
unless(-f 'data.h')
  {
    open(A, ">data.h") or die "could not open data.h";
    print A <<EEEE;
#ifndef DATA__H
#define DATA__H

#ifdef __cplusplus
extern "C" {
#endif

/*ADD*/

#ifdef __cplusplus
}
#endif

#endif
EEEE
    close(A);
  }

# get file length
my (undef, undef, undef, undef, undef, undef, undef, $filesize) = stat($filename);

# now process the file
rename("data.h", "data.hh") or die "could not rename";

open(IN, "data.hh") or die "could not open data.hh";
open(OUT, ">data.h") or die "could not open data.h";
my $flag=0;
while(<IN>)
  {
    $flag=1 if /$file/o;
    $_="extern GLubyte $file;\n#define ${file}LEN $filesize\n\n/*ADD*/\n" if m{/\*ADD\*/} && !$flag;
    print OUT;
  }
close(OUT);
close(IN);

unlink("data.hh") or die "could not unlink data.hh";

# unlock
if($ENV{TERM})
{
    flock(LOCK, LOCK_UN);
    close(LOCK);
}

exit 0;
