/* Copyright (c) 2004 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

// $Header: /code/doj/constant.hpp,v 1.4 2005/02/26 19:31:33 doj Exp $

#ifndef CONSTANT__HPP
#define CONSTANT__HPP

#include <cmath>

// the constants were ripped from GNU LIBC

#ifndef M_E
/// the mathematical constant e=2.71...
#define M_E		2.7182818284590452354
#ifndef M_1_E
/// the mathematical constant 1/e
#define M_1_E		0.36787944117144232159
#endif
#endif
#ifndef M_LOG2E
/// the mathematical constant log_2(e)=1.44...
#define M_LOG2E         1.4426950408889634074
#endif
#ifndef M_LOG10E
/// the mathematical constant log_10(e)=0.43...
#define M_LOG10E	0.43429448190325182765
#endif
#ifndef M_LN2
/// the mathematical constant ln(2)=0.69...
#define M_LN2		0.69314718055994530942
#endif
#ifndef M_LN10
/// the mathematical constant ln(10)=2.30...
#define M_LN10		2.30258509299404568402
#endif
#ifndef M_PI
/// the mathematical constant pi=3.14...
#define M_PI		3.14159265358979323846
#endif
#ifndef M_PI_2
/// the mathematical constant pi/2=1.57...
#define M_PI_2		1.57079632679489661923
#endif
#ifndef M_PI_4
/// the mathematical constant pi/4=0.78...
#define M_PI_4		0.78539816339744830962
#endif
#ifndef M_1_PI
/// the mathematical constant 1/pi=0.31...
#define M_1_PI		0.31830988618379067154
#endif
#ifndef M_2_PI
/// the mathematical constant 2/pi=0.63...
#define M_2_PI		0.63661977236758134308
#endif
#ifndef M_2_SQRTPI
/// the mathematical constant 2/sqrt(pi)=1.12...
#define M_2_SQRTPI	1.12837916709551257390
#endif
#ifndef M_SQRT2
/// the mathematical constant sqrt(2)=1.41...
#define M_SQRT2	        1.41421356237309504880
#endif
#ifndef M_SQRT1_2
/// the mathematical constant 1/sqrt(2)=0.707...
#define M_SQRT1_2	0.70710678118654752440
#endif

#endif
