/* Copyright (c) 2004..2009 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

// $Header: /code/doj/rand.hpp,v 1.10 2009/02/11 01:44:20 doj Exp $

#ifndef RAND__HPP
#define RAND__HPP

#ifdef __unix__
#include <sys/types.h>
#include <unistd.h>
#endif

#include <cstdlib>
#include <cstdio>
#include <time.h>

namespace doj
{

  /**
     returns a random double between 0 and max. You should call
     srand(...) before, to start with a random seed.
     @return random double between 0 and 1
  */
  inline double frand(const double max=1.0)
    {
      return drand48()*max;
    }

  /// @return a random double between -1 and 1. See frand()
  inline double frand2()
    {
      return frand(2.0)-1.0;
    }

  /// initialize the random generator with a good seed
  inline void srand()
  {
#ifdef __linux__
    FILE *f=fopen("/dev/urandom", "rb");
    if(f)
      {
	long int i;
	fread(&i, sizeof(i), 1, f);
	::srand48(i);
	unsigned int u;
	fread(&u, sizeof(u), 1, f);
	::srand(u);
	fclose(f);
      }
    else
#endif
      {
	const time_t t=time(NULL);

	::srand48(t
#ifdef __unix__
		  ^getpid()
#endif
		  );

	::srand(t
#ifdef __unix__
		^getpid()
#endif
		);
      }
  }

}

#endif

#ifdef TESTRAND
#include <iostream>
int main()
{
  doj::srand();
  std::cout << doj::frand() << std::endl;
}
#endif
