#include "flash.h"

#include "doj/gl.hpp"
using namespace doj;

Flash& Flash::from(GLfloat r, GLfloat g, GLfloat b, GLfloat a)
{
  fromColor[0]=r;
  fromColor[1]=g;
  fromColor[2]=b;
  fromColor[3]=a;
  return *this;
}

Flash& Flash::to(GLfloat r, GLfloat g, GLfloat b, GLfloat a)
{
  toColor[0]=r;
  toColor[1]=g;
  toColor[2]=b;
  toColor[3]=a;
  return *this;
}

int Flash::init()
{
  return 0;
}

bool Flash::draw(const int time)
{
  bool ret=true;

  if(starttime==-1)
    starttime=time;

  float t=(time-starttime)/1000.0 / flashtime;
  if(t > 1)
    {
      t=1;
      ret=false;
    }
  else if(t<0)
    t=0;


  gluOrthoBefore(screen.width, screen.height);
  {
    const float t1=1.0-t;
    glColor4f(fromColor[0]*t1 + toColor[0]*t, fromColor[1]*t1 + toColor[1]*t, fromColor[2]*t1 + toColor[2]*t, fromColor[3]*t1 + toColor[3]*t);
    glBegin(GL_QUADS);
    {
      glVertex3f(-1, -1, 1);
      glVertex3f(+1, -1, 1);
      glVertex3f(+1, +1, 1);
      glVertex3f(-1, +1, 1);
    }
    glEnd();
  }
  gluOrthoAfter();

  return ret;
}
