#ifndef FLASH__H
#define FLASH__H

#include "object.h"

class Flash : public Object
{
 protected:
  GLfloat fromColor[4];
  GLfloat toColor[4];
  int starttime;
  float flashtime;

 public:
  Flash(const string& n="unknown Flash") :
    Object(n),
    starttime(-1),
    flashtime(1.0)
    {
      fromColor[0]=0;
      fromColor[1]=0;
      fromColor[2]=0;
      fromColor[3]=0;
      toColor[0]=1;
      toColor[1]=1;
      toColor[2]=1;
      toColor[3]=1;
      blendEnable=true;
      zbufferEnable=false;
      flatEnable=true;
    }

  Flash& from(GLfloat r, GLfloat g, GLfloat b, GLfloat a=0);
  Flash& to(GLfloat r, GLfloat g, GLfloat b, GLfloat a=1);
  Flash& time(const float t) { flashtime=t; return *this; }

  virtual int init();

  void reset() { starttime=-1; }
  bool draw(const int time);
};

#endif
