#ifndef FONT__H
#define FONT__H

#include <ft2build.h>
#include FT_FREETYPE_H

#include "doj/color.hpp"
using namespace doj;

#include "object.h"

class Font : public ColorObject
{
 public:
  bool shaded;
  rgba colorLight;
  rgba colorDark;

 protected:
  GLfloat charAdvance[128];
  GLfloat charWidth[128];
  GLfloat charHeight[128];
  GLfloat ty[128];
  GLuint textures[128];

  static FT_Library library;
  static bool libraryInit;
  static FT_Face face;

 public:
  static const int Left;
  static const int Center;
  static const int Right;
  
  Font(const string& n="Font");
  virtual ~Font() { }

  virtual void deinit();
  int init();

  int init(const FT_Byte *font, const int fontLen, const int fontindex=0);

  GLfloat print(const string& str, 
		const GLfloat x=0, const GLfloat y=0, const GLfloat z=0, 
		const int align=0
		) const;

  GLfloat print(const char c, 
		const GLfloat x=0, const GLfloat y=0, const GLfloat z=0,
		const int align=0
		) const;

  GLfloat width(const char c) const;
  GLfloat width(const string& str) const;

 protected:
  void draw(const char c) const;
};

#endif
