#ifndef GRID__H
#define GRID__H

#include "object.h"

class Grid : public Object
{
 public:
  Grid(const string& n="Grid") :
    Object(n)
    {

    }

  int init()
    {
      listID=glGenLists(1);
      if(listID==0)
	{
	  cerr << "Grid::init(): could not generate list" << endl;
	  return -1;
	}

      glPushMatrix();
      glLoadIdentity();
      glNewList(listID, GL_COMPILE);
      glBegin(GL_LINES);
      {
	const int g=20;
	glColor3f(.5, .5, 1);
	glVertex3i(0, -g, 0); 
	glVertex3i(0, 0, 0); 

	glColor3f(.75, .75, 1);
	glVertex3i(0, g, 0);
	glVertex3i(0, 0, 0); 
	for(int i=-g; i<=g; i++)
	  {
	    glColor3f((float)(i+g)/float(2*g)*.5+.5, .5, .5);
	    glVertex3f(i, 0, -g); glVertex3d(i, 0, g);
	    glColor3f(.5, (float)(i+g)/float(2*g)*.5+.5, .5);
	    glVertex3f(-g, 0, i); glVertex3d(g, 0, i);
	  }
      }
      glEnd();
      glEndList();

      return 0;
    }

};

#endif
