#include "camera.h"
#include "cube.h"
#include "flash.h"
#include "font.h"
#include "light.h"
#include "scroller.h"

#include "doj/gl.hpp"
using namespace doj;

extern Font *font1;

namespace Last 
{

  static int starttime=-1;
  static Cube *cube=0;
  static Light *light=0;
  static Flash *flash=0;
  static bool flashrun=true;

  static Camera cam;

  static int sync=-1;

  int init()
  {
    light=new Light();
    light->pos=fvector(1,1,10);
    light->point();
    light->setLight(0);
    light->init();

    cube=new Cube();
    cube->setLight(light);
    cube->colorLight(.2, 1, .2, 1, ColorObject::Ambient);
    cube->colorLight(.5, 1, .5, 1, ColorObject::Diffuse);
    cube->colorLight(.8, 1, .8, 1, ColorObject::Specular);
    cube->shininess=100;
    cube->init();

    flash=new Flash();
    flash->from(0,0,0,1);
    flash->to(0,0,0,0);
    flash->time(10);

    return 0;
  }

  void draw(const int time)
  {
    for(modSync_t::iterator i=modSync.begin(); i!=modSync.end(); /*nothing here*/)
      {
	const int e=*i>>4;
	if(e==0xf)
	  {
	    sync=*i&0xf;
	    i=modSync.erase(i);
	  }
	else
	  ++i;
      }

    if(starttime==-1)
      {
	starttime=time;
	Scroller::init(1);
      }

    const float t=(time-starttime)/1000.0;

    cam.position();

    light->draw();

    glPushMatrix();
    {
      glRotatef(t*2.0, 0, 1, 0);
      glRotatef(t*1.765324, 1, 0, 0);
      cube->drawSingle();
    }
    glPopMatrix();

    Scroller::draw(time);

    if(t>10)
      {
	float a=sin(t-10.0);
	if(a<0)
	  a=0;
	font1->color(1, .3, .3, a);
	font1->colorLight=rgba(1, .5, .5, a);
	font1->colorDark=rgba(1, .1, .1, a);
	font1->shaded=true;
	font1->zbufferEnable=false;
	gluOrthoBefore(screen.width, screen.height);
	{
	  glScalef(.1, .2, 1);
	  font1->before();
	  font1->print("you may press escape", 0, 0, 1, Font::Center);
	  font1->after();
	}
	gluOrthoAfter();
      }

    if(flashrun)
      {
	flash->before();
	flashrun=flash->draw(time);
	flash->after();
      }
  }

};
