#ifndef LIGHT__H
#define LIGHT__H

#include "main.h"
#include "object.h"

#include <vektor.hpp>
using namespace doj;

#include <string>
using namespace std;

class Light
{
 public:
  string name;
  GLenum  num;
  GLfloat ambient[4];
  GLfloat diffuse[4];
  GLfloat specular[4];
  fvector pos;
  fvector dir;
  GLfloat spotExp;
  GLfloat spotCutoff;
  GLfloat constAttenuation;
  GLfloat linearAttenuation;
  GLfloat quadAttenuation;

  Light(const string& n="unknown Light") :
    name(n),
    num((GLenum)0),
    pos(0, 0, 0, 1),
    dir(0, 0, -1),
    spotExp(0),
    spotCutoff(180),
    constAttenuation(1),
    linearAttenuation(0),
    quadAttenuation(0)
    {
      ambient[0]=ambient[1]=ambient[2]=0; ambient[3]=1;
      diffuse[0]=diffuse[1]=diffuse[2]=diffuse[3]=1;
      specular[0]=specular[1]=specular[2]=specular[3]=1;
    }

  int init()
    {
      if(num>=GL_LIGHT0 && num<static_cast<GLenum>(GL_LIGHT0+gl_max_lights))
	{
	  glLightfv(num, GL_AMBIENT, ambient);
	  glLightfv(num, GL_DIFFUSE, diffuse);
	  glLightfv(num, GL_SPECULAR, specular);
	  glLightf (num, GL_SPOT_EXPONENT, spotExp);
	  glLightf (num, GL_SPOT_CUTOFF, spotCutoff);
	  glLightf (num, GL_CONSTANT_ATTENUATION, constAttenuation);
	  glLightf (num, GL_LINEAR_ATTENUATION, linearAttenuation);
	  glLightf (num, GL_QUADRATIC_ATTENUATION, quadAttenuation);
	}

      return 0;
    }

  int setLight(int i)
    {
      if(i>=GL_LIGHT0)
	i-=GL_LIGHT0;
      if(i<gl_max_lights)
	{
	  num = Object::lightArray[i];
	  return 0;
	}
      return -1;
    }

  Light& draw()
    {
      if(num>=GL_LIGHT0 && num<static_cast<GLenum>(GL_LIGHT0+gl_max_lights))
	{
	  GLfloat a[4];

	  a[0]=pos.x;
	  a[1]=pos.y;
	  a[2]=pos.z;
	  a[3]=pos.w;
	  glLightfv(num, GL_POSITION, a);

	  if(spotCutoff!=180)
	    {
	      a[0]=dir.x;
	      a[1]=dir.y;
	      a[2]=dir.z;
	      a[3]=dir.w;
	      glLightfv(num, GL_SPOT_DIRECTION, a);
	    }
	}
      return *this;
    }

  Light& drawSingle()
    {
      draw();
      return *this;
    }

  Light& before()
    {
      return *this;
    }

  Light& after()
    {
      return *this;
    }

  Light& point()
    {
      pos.w=1;
      return *this;
    }

  Light& vector()
    {
      pos.w=0;
      return *this;
    }

};

#endif
