#include <iostream>

using namespace std;

#include "object.h"
#include "light.h"
#include "tga.h"

#include <functions.hpp>
using namespace doj;

GLint gl_max_lights=8;

#ifndef GL_LIGHT8
#define GL_LIGHT8 0
#endif
#ifndef GL_LIGHT9
#define GL_LIGHT9 0
#endif
#ifndef GL_LIGHT10
#define GL_LIGHT10 0
#endif
#ifndef GL_LIGHT11
#define GL_LIGHT11 0
#endif
#ifndef GL_LIGHT12
#define GL_LIGHT12 0
#endif
#ifndef GL_LIGHT13
#define GL_LIGHT13 0
#endif
#ifndef GL_LIGHT14
#define GL_LIGHT14 0
#endif
#ifndef GL_LIGHT15
#define GL_LIGHT15 0
#endif

const GLenum Object::lightArray[] = {
  (GLenum)GL_LIGHT0,
  (GLenum)GL_LIGHT1,
  (GLenum)GL_LIGHT2,
  (GLenum)GL_LIGHT3,
  (GLenum)GL_LIGHT4,
  (GLenum)GL_LIGHT5,
  (GLenum)GL_LIGHT6,
  (GLenum)GL_LIGHT7,
  (GLenum)GL_LIGHT8,
  (GLenum)GL_LIGHT9,
  (GLenum)GL_LIGHT10,
  (GLenum)GL_LIGHT11,
  (GLenum)GL_LIGHT12,
  (GLenum)GL_LIGHT13,
  (GLenum)GL_LIGHT14,
  (GLenum)GL_LIGHT15,
};


Object::Object(const string& n) :
  listID(0),
  textureID(0),
  outside(true),
  textureEnable(false),
  textureType(GL_TEXTURE_2D),
  textureWrap(true),
  textureMipmap(true),
  textureModetype(GL_MODULATE),
  textureScale(1),
  textureRotate(0),
  blendEnable(false),
  blendSrc(GL_SRC_ALPHA),
  blendDst(GL_ONE_MINUS_SRC_ALPHA),
  alphaEnable(false),
  fogEnable(false),
  lightsEnable(false),
  lineWidth(1),
  linesmoothEnable(false),
  pointsmoothEnable(false),
  polysmoothEnable(false),
  polygonmode(GL_FILL),
  zbufferEnable(true),
  backfacecullEnable(true),
  normalizeEnable(false),
  rescalenormalEnable(false),
  flatEnable(false),
  name(n)
{
  for(int i=0; i<gl_max_lights; i++)
    lightEnable[i]=false;
}

Object::~Object() { }

void Object::deinit()
{
  glDeleteLists(listID, 1);
  glDeleteTextures(1, &textureID);
}

void Object::before() const
{
  if(textureEnable)
    {
      glEnable(textureType);
      glBindTexture(textureType, textureID); // we need this, so the next calls affect the current or the default(which should be not used) texture

      glTexParameteri(textureType, GL_TEXTURE_MIN_FILTER, textureMipmap?GL_LINEAR_MIPMAP_LINEAR:GL_NEAREST);
      glTexParameteri(textureType, GL_TEXTURE_MAG_FILTER, textureMipmap?GL_LINEAR:GL_NEAREST);
      glTexParameteri(textureType, GL_TEXTURE_WRAP_S, textureWrap?GL_REPEAT:GL_CLAMP);
      glTexParameteri(textureType, GL_TEXTURE_WRAP_T, textureWrap?GL_REPEAT:GL_CLAMP);

      glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, textureModetype);

      if(textureScale!=1 || textureRotate!=0)
	{
	  glMatrixMode(GL_TEXTURE);
	  glLoadIdentity();
	  glTranslatef(.5, .5, 0);
	  glScalef(textureScale, textureScale, textureScale);
	  glRotatef(textureRotate, 0, 0, 1);
	  glTranslatef(-.5, -.5, 0);
	  glMatrixMode(GL_MODELVIEW);
	}
    }
  if(blendEnable)
    {
      glEnable(GL_BLEND);
      glBlendFunc(blendSrc, blendDst);
    }
  if(alphaEnable)
    glEnable(GL_ALPHA);
  if(fogEnable)
    glEnable(GL_FOG);
  if(lightsEnable)
    {
      glEnable(GL_LIGHTING), glShadeModel(GL_SMOOTH);
      for(int i=0; i<gl_max_lights; i++)
	lightEnable[i]?glEnable(lightArray[i]):glDisable(lightArray[i]);
    }
  if(lineWidth!=1)
      glLineWidth(lineWidth);
  if(linesmoothEnable)
    glEnable(GL_LINE_SMOOTH);
  if(pointsmoothEnable)
    glEnable(GL_POINT_SMOOTH);
  if(polysmoothEnable)
    glEnable(GL_POLYGON_SMOOTH);
  if(zbufferEnable)
    glEnable(GL_DEPTH_TEST);
  if(backfacecullEnable)
    glEnable(GL_CULL_FACE);
  if(normalizeEnable)
    glEnable(GL_NORMALIZE);
  if(rescalenormalEnable)
    {
#ifdef GL_VERSION_1_2
      glEnable(GL_RESCALE_NORMAL);
#else
      glEnable(GL_NORMALIZE);
#endif
    }
  if(flatEnable)
    glShadeModel(GL_FLAT);

  glPolygonMode(GL_FRONT_AND_BACK, polygonmode);
}

void Object::after() const
{
  if(textureEnable)
    {
      glDisable(textureType);
      if(textureScale!=1 || textureRotate!=0)
	{
	  glMatrixMode(GL_TEXTURE);
	  glLoadIdentity();
	  glMatrixMode(GL_MODELVIEW);
	}
    }
  if(blendEnable)
    glDisable(GL_BLEND);
  if(alphaEnable)
    glDisable(GL_ALPHA);
  if(fogEnable)
    glDisable(GL_FOG);
  if(lightsEnable)
    glDisable(GL_LIGHTING);
  if(lineWidth!=1)
    glLineWidth(1);
  if(linesmoothEnable)
    glDisable(GL_LINE_SMOOTH);
  if(pointsmoothEnable)
    glDisable(GL_POINT_SMOOTH);
  if(polysmoothEnable)
    glDisable(GL_POLYGON_SMOOTH);
  if(zbufferEnable)
    glDisable(GL_DEPTH_TEST);
  if(backfacecullEnable)
    glDisable(GL_CULL_FACE);
  if(normalizeEnable)
    glDisable(GL_NORMALIZE);
  if(rescalenormalEnable)
    {
#ifdef GL_VERSION_1_2
      glDisable(GL_RESCALE_NORMAL);
#else
      glDisable(GL_NORMALIZE);
#endif
    }
  if(flatEnable)
    glShadeModel(GL_SMOOTH);
}

void Object::draw()
{
  if(listID)
    glCallList(listID);
}

void Object::drawSingle()
{
  before();
  draw();
  after();
}

void Object::texture(const GLuint t)
{
  textureID=t;
  textureEnable=true;
}

void Object::texture(const string& filename, const bool mipmap)
{
  texture(loadTGA(filename, mipmap));
}

void Object::texture(const GLubyte *mem, const bool mipmap)
{
  texture(loadTGA(mem, mipmap));
}

ColorObject::ColorObject(const string& n) :
  Object(n),
  r(1), g(1), b(1), a(1),
  shininess(10)
{
  ambient[0]=ambient[1]=ambient[2]=.1; ambient[3]=1;
  diffuse[0]=diffuse[1]=diffuse[2]=.5; diffuse[3]=1;
  specular[0]=specular[1]=specular[2]=1; specular[3]=1;
  emission[0]=emission[1]=emission[2]=0; emission[3]=1;
}

void ColorObject::setMaterial(GLenum dir) const
{
  glMaterialfv(dir, GL_AMBIENT, ambient);
  glMaterialfv(dir, GL_DIFFUSE, diffuse);
  glMaterialfv(dir, GL_SPECULAR, specular);
  glMaterialf (dir, GL_SHININESS, shininess);
  glMaterialfv(dir, GL_EMISSION, emission);
}

void ColorObject::color(const GLfloat rr, const GLfloat gg, const GLfloat bb, const GLfloat aa)
{
  r=clamp(rr);
  g=clamp(gg);
  b=clamp(bb);
  a=clamp(aa);
}

int ColorObject::setLight(int l, const bool e)
{
  if(l>=GL_LIGHT0)
    l-=GL_LIGHT0;
  if(l<0 && l>=gl_max_lights)
    return -1;

  lightEnable[l]=e;
  if(e)
    lightsEnable=e;

  return 0;
}

int ColorObject::setLight(const Light& l, const bool e)
{
  return setLight(l.num, e);
}

int ColorObject::setLight(const Light *l, const bool e)
{
  return setLight(l->num, e);
}

void ColorObject::colorLight(const GLfloat rr, const GLfloat gg, const GLfloat bb, const GLfloat aa, const Color_t typ)
{
  GLfloat *p=0;
  switch(typ)
    {
    case Ambient: p=ambient; break;
    case Diffuse: p=diffuse; break;
    case Specular: p=specular; break;
    case Emission: p=emission; break;
    default: cerr << "ColorObject::color(): wrong color typ specified" << endl;
    }
  if(p)
    {
      p[0]=clamp(rr);
      p[1]=clamp(gg);
      p[2]=clamp(bb);
      p[3]=clamp(aa);
    }
}
