#ifndef OBJECT__H
#define OBJECT__H

#include <string>
using namespace std;

#include "main.h"

extern GLint gl_max_lights;

class Light;

class Object
{
 public:
  static const GLenum lightArray[];

  GLuint listID;
  GLuint textureID;

  bool outside;
  bool textureEnable;
  GLenum textureType;
  bool textureWrap;
  bool textureMipmap;
  GLint textureModetype;
  GLfloat textureScale;
  GLfloat textureRotate;
  bool blendEnable;
  GLenum blendSrc;
  GLenum blendDst;
  bool alphaEnable;
  bool fogEnable;
  bool lightsEnable;
  bool lightEnable[8];
  GLfloat lineWidth;
  bool linesmoothEnable;
  bool pointsmoothEnable;
  bool polysmoothEnable;
  GLenum polygonmode;
  bool zbufferEnable;
  bool backfacecullEnable;
  bool normalizeEnable;
  bool rescalenormalEnable;
  bool flatEnable;
  string name;

  Object(const string& n="unknown Object");

  virtual ~Object();

  virtual void deinit();

  virtual void before() const;
  virtual void after() const;

  virtual void draw();

  void drawSingle();

  virtual int init() = 0;

  void texture(const GLuint t);
  void texture(const string& filename, const bool mipmap=true);
  void texture(const GLubyte*, const bool mipmap=true);
};

class ColorObject : public Object
{
 protected:
  GLfloat r,g,b,a;

 public:
  enum Color_t { Ambient, Diffuse, Specular, Emission };

  GLfloat ambient[4];
  GLfloat diffuse[4];
  GLfloat specular[4];
  GLfloat shininess;
  GLfloat emission[4];

  ColorObject(const string& n="unknown ColorObject");

  /// dir:=GL_FRONT, GL_BACK, GL_FRONT_AND_BACK
  void setMaterial(GLenum dir=GL_FRONT_AND_BACK) const;

  virtual void color(const GLfloat rr, const GLfloat gg, const GLfloat bb, const GLfloat aa=1);
  void colorLight(const GLfloat rr, const GLfloat gg, const GLfloat bb, const GLfloat aa=1, const Color_t typ=Diffuse);

  int setLight(int l, const bool e=true);
  int setLight(const Light& l, const bool e=true);
  int setLight(const Light *l, const bool e=true);

};

#endif
