#ifndef OSC__H
#define OSC__H

#include <fmod.h>
#include <fmod_errors.h>

#ifdef __linux__
#include <wincompat.h>
#endif

#include "object.h"

class Osc : public ColorObject
{
  friend void* callbackshort(void *originalbuffer, void *newbuffer, int length, void*);
  friend void* callbackfloat(void *originalbuffer, void *newbuffer, int length, void*);

 protected:
  float *buf;
  int bufLen;
  FSOUND_DSPUNIT *callback;
  bool callbackrunning;

 public:
  Osc(const string& n="unknown Osc");
  virtual ~Osc();

  virtual int init();
  virtual void draw();

  void reset();

 private:
  Osc(const Osc&);
  Osc& operator=(const Osc&);
};

#endif
