#include <iostream>
#include <sstream>
using namespace std;

#include "camera.h"
#include "font.h"

#include "data.h"

#include "doj/gl.hpp"
using namespace doj;

extern Font *font1;

namespace Scroller
{
  static const char *text =
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "danke an rp/fr\n"
  "seine musik ist\n"
  "ein echter Ohrwurm.\n"
  "\n"
  "Sie sehen gerade\n"
  "den Swoosh-Effekt.\n"
  "Gleich kommt was neues.\n"
  ;

  static int starttime=-1;

  static int offset=6;

  static Camera cam;

  static int mode=0;

  int init(const int m)
  {
    mode=m;
    starttime=-1;
    return 0;
  }

  static int draw(const float t, istream& is, const int align)
  {
    font1->before();
    int i=0;
    while(is)
      {
	string s;
	getline(is, s);
	if(is)
	  {
	    const float y=t-static_cast<float>(i-offset);
	    if(y<-offset*2-1)
	      break;
	    if(y<offset*2+1)
	      font1->print(s, (align==Font::Left)?-offset*2.6:0, y, 0, align);
	  }
	i++;
      }
    font1->after();
    return i;
  }

  void draw(const int time)
  {
    if(starttime==-1)
      {
	starttime=time;
      }

    font1->color(.3, .3, 1, 1);
    font1->colorLight=rgba(.5, .5, 1, 1);
    font1->colorDark=rgba(.1, .1, 1, 1);
    font1->shaded=true;
    font1->zbufferEnable=false;

    glLoadIdentity();
    activeCamera=&cam;
    cam.position();

    switch(mode)
      {
      case 0:
	{
	  const float t=(time-starttime)/1000.0f * 2.0;
	  offset=3;
	  glScale(.5);
	  std::istringstream s(text);
	  draw(t, s, Font::Center);
	}
	break;

      case 1:
      default:
	{
	  const float t=(time-starttime)/1000.0f * 8.0;
	  offset=6;
	  glScale(.25);
	  std::istringstream s(reinterpret_cast<char*>(&TXTscrolltext));
	  int l=draw(t, s, Font::Left);
	  // can we exit the demo?
	  if(t>l+offset*2)
	    {
	      starttime=-1;
	      escPressed();
	    }
	}
	break;
      }
  }

};
