#include <vector>
using namespace std;

#include <cmath>

#include <gl.hpp>
#include <vektor.hpp>
using namespace doj;

#include "sphere.h"

void ::Sphere::point(const float x, const float y)
{
  glTexCoord2f(x, y);
  
  fvector a;
  a.sphere(x, y, radius);
  
  fvector b(a);
  b.normalise();
  if(!outside)
    b.invert();
  glNormal(b);
      
  glVertex(a);
}

::Sphere::Sphere(const string& n) :
  ColorObject(n),
  elements(20),
  radius(1),
  amigaball(false),
  type(Simple)
{
}

struct FACET {
  fvector p1, p2, p3;
};

int ::Sphere::init()
{
  listID=glGenLists(1);
  if(listID==0)
    {
      cerr << "Sphere::init(): could not generate list" << endl;
      return -1;
    }

  GLfloat color[][4] = {
    { r, g, b, a },
    { 1,.2,.2, 1 },
  };

  glPushMatrix();
  glLoadIdentity();

  glNewList(listID, GL_COMPILE);
  glBindTexture(GL_TEXTURE_2D, textureID);
  setMaterial();

  switch(type)
    {
    case Triangle:
      {
	if(elements<0)
	  elements=0;

	// this will make ((4^elements) * 8) triangles

	typedef vector<struct FACET> v_t;

	v_t f(intpow(4, elements)*8);

	// Create the level 0 object
	fvector p[] = {
	  fvector(0, 0, 1),
	  fvector(         0,         0,-1),
	  fvector(-M_SQRT1_2,-M_SQRT1_2, 0),
	  fvector( M_SQRT1_2,-M_SQRT1_2, 0),
	  fvector( M_SQRT1_2, M_SQRT1_2, 0),
	  fvector(-M_SQRT1_2, M_SQRT1_2, 0),
	};
	    
	f[0].p1 = p[0]; f[0].p2 = p[3]; f[0].p3 = p[4];
	f[1].p1 = p[0]; f[1].p2 = p[4]; f[1].p3 = p[5];
	f[2].p1 = p[0]; f[2].p2 = p[5]; f[2].p3 = p[2];
	f[3].p1 = p[0]; f[3].p2 = p[2]; f[3].p3 = p[3];
	f[4].p1 = p[1]; f[4].p2 = p[4]; f[4].p3 = p[3];
	f[5].p1 = p[1]; f[5].p2 = p[5]; f[5].p3 = p[4];
	f[6].p1 = p[1]; f[6].p2 = p[2]; f[6].p3 = p[5];
	f[7].p1 = p[1]; f[7].p2 = p[3]; f[7].p3 = p[2];
	int nt = 8;		// number of triangles

	if (elements >= 1)
	  /* Bisect each edge and move to the surface of a unit sphere */
	  for (int it=0; it<elements; it++) 
	    {
	      const int ntold = nt;
	      for (int i=0; i<ntold; i++)
		{
		  fvector pa=(f[i].p1+f[i].p2) * 0.5f;
		  fvector pb=(f[i].p2+f[i].p3) * 0.5f;
		  fvector pc=(f[i].p3+f[i].p1) * 0.5f;
		  pa.normalise();
		  pb.normalise();
		  pc.normalise();
		  f[nt].p1 = f[i].p1; f[nt].p2 = pa; f[nt].p3 = pc; nt++;
		  f[nt].p1 = pa; f[nt].p2 = f[i].p2; f[nt].p3 = pb; nt++;
		  f[nt].p1 = pb; f[nt].p2 = f[i].p3; f[nt].p3 = pc; nt++;
		  f[i].p1 = pa;
		  f[i].p2 = pb;
		  f[i].p3 = pc;
		}
	    }

	glBegin(GL_TRIANGLES);
	glColor4fv(color[0]);
	for(v_t::iterator i=f.begin(); i!=f.end(); ++i)
	  {
	    fvector t;

	    i->p1.w=1;
	    t.sphere2karth(i->p1); glTexCoord(t);
	    glNormal(i->p1);
	    glVertex(i->p1 * radius);

	    i->p2.w=1;
	    t.sphere2karth(i->p2); glTexCoord(t);
	    glNormal(i->p2);
	    glVertex(i->p2 * radius);

	    i->p3.w=1;
	    t.sphere2karth(i->p3); glTexCoord(t);
	    glNormal(i->p3);
	    glVertex(i->p3 * radius);
	  }
	glEnd();

      }
      break;

    case Simple:
    default:
      if(!outside)
	glFrontFace(GL_CW);
      const float yd=1.0/elements;
      int z=0;
      for(int y=0; y<elements; y++)
	{
	  glBegin(GL_QUAD_STRIP);
	  if(amigaball)
	    z=y&1;
	  for(int x=0; x<=elements; x++)
	    {
	      glColor4fv(color[z]);
	      const float xx=(float)x*yd;
	      const float yy=(float)y*yd;
	      point(xx, yy+yd);
	      point(xx, yy);
		  
	      if(amigaball)
		(++z)%=2;
	    }
	  glEnd();
	}
      if(!outside)
	glFrontFace(GL_CCW);
      break;
    }

  glEndList();
  glPopMatrix();

  if(amigaball)
    polysmoothEnable=false;

  return 0;
}
