#include "sprite.h"

Sprite::Sprite(const string& n) :
  ColorObject(n)
{
}

int Sprite::init()
{
  listID=glGenLists(1);
  if(listID==0)
    {
      e("could not generate a list for sprite");
      return -1;
    }

  glPushMatrix();
  glLoadIdentity();

  glNewList(listID, GL_COMPILE);
  glBindTexture(GL_TEXTURE_2D, textureID);
  glColor4f(r, g, b, a);
  glNormal3f(0,0,+1);
  glBegin(GL_QUADS);
  {
    glTexCoord2f( 1, 0); glVertex2f(-1,-1);
    glTexCoord2f( 0, 0); glVertex2f(+1,-1);
    glTexCoord2f( 0, 1); glVertex2f(+1,+1);
    glTexCoord2f( 1, 1); glVertex2f(-1,+1);
  }
  glEnd();
  glEndList();
  
  glPopMatrix();
  return 0;
}
