#include "star.h"
#include <cmath>
#include <vektor.hpp>
using namespace doj;

static inline void coord(const fvector& v)
{
  glTexCoord2f((v.x+1.0)/2.0, (v.y+1.0)/2.0);
  glVertex3f(v.x,v.y,v.z);
}

int Star::init ()
{
  listID=glGenLists(1);
  if(listID==0)
    {
      e("could not generate a list for Star");
      return -1;
    }

  glPushMatrix();
  glLoadIdentity();
  glNewList(listID, GL_COMPILE);
  glBindTexture(GL_TEXTURE_2D, textureID);
  glBegin(GL_TRIANGLES);
  glColor4f(r,g,b,a);
  setMaterial();

  for (int i=0; i<num_; i++)
    {
      float a = (2.0*M_PI / num_) * i;
      float xa = sin(a);
      float ya = cos(a);

      // Achtung diese Links und rechts ist vertausch!

      /*----- left part ------*/
      float bl = a + (M_PI/num_);
      float xl0 = r_*sin(bl);
      float yl0 = r_*cos(bl);

      /*----- right part ------*/
      float br = a - (M_PI/num_);
      float xr0 = r_*sin(br);
      float yr0 = r_*cos(br);

      fvector oben(xa, ya, 0);
      fvector links(xl0, yl0, 0);
      fvector rechts(xr0, yr0, 0);
      fvector mitte(0,0,flat?0:.2);

      fvector n1(oben, rechts);
      fvector n2(oben, mitte);
      n2.cross(n1).normalise();
      glNormal3f(n2.x, n2.y, n2.z);
      coord(oben);
      coord(rechts);
      coord(mitte);

      fvector n3(oben, mitte);
      fvector n4(oben, links);
      n3.cross(n4).normalise();
      glNormal3f(n3.x, n3.y, n3.z);
      coord(oben);
      coord(mitte);
      coord(links);
    }
  glEnd();

  glEndList();
  glPopMatrix();

  return 0;
}
