#ifndef STAR__H
#define STAR__H

#include "object.h"

class Star : public ColorObject
{
 protected:
  float r_;
  int   num_;

 public:
  bool flat;

 public:
  Star (const string& n="Star", const int number=5, const float rr=0.3) : 
    ColorObject(n),
    r_(0.3), 
    num_(5),
    flat(false)
    {
      num(number);
      radius(rr);
    }

  virtual int init ();

  void num(const int n)
    {
      if (n >= 2)
	num_=n;
    }

  void radius(float f)
    {
      if(f>0)
	r_=f;
    }

};

#endif
