/*
 * Marke = z50
 * Pos=30
 * ca. 20..25 Sekunden
 */
#include <cmath>

#include <fstream>
using namespace std;

#include "background.h"
#include "camera.h"
#include "camerapath.h"
#include "flash.h"
#include "light.h"
#include "main.h"
#include "sphere.h"
#include "star.h"

#include "data.h"

#include "doj/rand.hpp"
using namespace doj;

namespace Starfield
{

  typedef enum { LIFTSTATE_BOTTOM=0, LIFTSTATE_UP, LIFTSTATE_DOWN, LIFTSTATE_STARTLIFT} liftState_t;

  typedef struct
  {
    float        x0;
    float        y0;
    float        z0;
    float        rand0;
    Object      *star;
    liftState_t  lift;		// 0=currently not lifted, 1=lifting up, 2=lifting down;
    float        startlift;	// dt we started the liftup
    float        maxlift;
  } AStar;

  static const float maxDemoTime = 23.0;

  static const float starsize   = 0.2;
  static const float zitter     = 0.5;
  static const int   rows       = 20;
  static const int   nstars     = rows*rows*2;
  static const float liftspeed  = 2.0;
  static const float liftedSizeFactor = 1.5;


  static AStar   *stars;
  static Star    *star;
  static bool    initialized = false;
  static int     starttime = -1;
  static float   last_dt = 0.0;	// last time the effect has been drawn
  static float   lastlifttime = 0.0; // last time a lift has been initiated

  static Camera     cam;
  static const float cam_z0 = 1.5;

  static Light   *light=0;

  static Flash   *flash=0;
  static bool    flashrun=true;

  Background *background=0;

  /*-- this variable is exported for the next effekt --*/
  float       backgroundSpinSpeed = 0.0;
  /*----------------------------------------------------------*/

  /*
   *======================== H E L P E R - F U N C T I O N S =======================
   */

  /*
   *
   */
#if 0
  static float gaussGlocke (float f)
  {
    if (f<0.0 || f>1.0)
      return 0.0;
    return sin((f*M_PI*2.0-M_PI)+1.0)/2.0;
  }
#endif

  /*
   *
   */
  static int countLifting (liftState_t state, float minlift, float maxlift)
  {
    int lu = 0;
    for (int i=0; i<nstars; i++)
      if (stars[i].lift==state && stars[i].maxlift>=minlift && stars[i].maxlift<=maxlift)
	lu++;
    return lu;
  }

  /*
   *
   */
  static float effektProgress (float dt, float min, float max)
  {
    if (dt>=maxDemoTime)
      return max;
    return min + (dt / maxDemoTime)*(max-min);
  }

  //////////////////////////////////////////////////////////////////////////////////////

  /*
   *
   */
  static void cleanup ()
  {
    if(light)
      delete light;
    if(star)
      delete star;
    if(flash)
      delete flash;
  }

  /*
   *
   */
  int init ()
  {
    if(initialized)
      return 0;

    atexit(cleanup);

    initialized = false;
    last_dt = 0.0;
    lastlifttime = 0.0;
    flashrun=true;

    if(!light)
      {
	light=new Light();
	if(light==NULL)
	  {
	    cerr << "Starfield::init(): could not alloc light" << endl;
	    return -1;
	  }
	light->pos=fvector(20,20,100000);
	light->point();
	light->setLight(0);
	if(light->init() < 0)
	  cerr << "Starfield::init(): could not init light" << endl;
      }

    if(!flash)
      {
	flash=new Flash("Starfield::flashFromWhite");
	if(!flash)
	  {
	    cerr << "Starfield::init(): could not alloc flash" << endl;
	    return -1;
	  }
	flash->from(1,1,1,0.5);
	flash->to  (0,0,0,0);
	flash->time(1);
      }

    if(!background)
      {
	background=new Background("Starfield::background");
	if(!background)
	  {
	    cerr << "Starfiels::init(): could not alloc background" << endl;
	    return -1;
	  }
	background->texture(&TGAwhirl1024);
	background->textureScale=.5;
	background->init();
      }

    if(!star)
      {
	star = new Star();
	if(!star)
	  {
	    cerr << "Starfield::init(): could not alloc star" << endl;
	    return -1;
	  }
	star->setLight(light);
	star->colorLight(169.0/256.0, 71.0/256.0,  1.0,         1.0, ColorObject::Diffuse);
	star->colorLight(40.0/256.0,   8.0/256.0,  219.0/256.0, 1.0, ColorObject::Ambient);
	star->colorLight(237.0/256.0, 222.0/256.0, 247.0/256.0, 1.0, ColorObject::Specular);
	star->shininess=0.5;
	star->init();
      }

    stars = new AStar[nstars];
    if(!stars)
      {
	cerr << "Starfield::init(): could not alloc stars" << endl;
	return -1;
      }
    int i=0;
    for (int y = -rows; y < rows; y++)
      {
	for (int x = -(rows/2); x < (rows/2); x++)
	  {
	    stars[i].rand0 = frand()*0.9 + 0.1;

	    stars[i].x0 = x; // + (frand()-0.5)*starsize;  // {-rows/2 .. rows/2} + {-starsize/2 .. starsize/2}
	    stars[i].y0 = y; // + (frand()-0.5)*starsize;  // {-rows/2 .. rows/2} + {-starsize/2 .. starsize/2}

	    stars[i].z0 = 0.0;
	    stars[i].star = star;
	    
	    stars[i].lift = LIFTSTATE_BOTTOM;
	    stars[i].startlift = 0.0;
	    stars[i].maxlift = 0.0;
	    i++;
	  }
      }

    initialized=true;
    return 0;
  }


  /*
   *
   */
  void draw (const int time)
  {
    for(modSync_t::iterator ii=modSync.begin(); ii!=modSync.end(); /*nothing here*/)
      {
	const int e=*ii>>4;
	if(e==5)
	  {
	    ii=modSync.erase(ii);
	  }
	else
	  ++ii;
      }

    if (!initialized)
      return;

    if(starttime==-1)
      starttime=time;

    const float dt = (float)(time-starttime) / 1000.0; // time between first call of draw after init and this one in seconds.

    const float ddt = dt - last_dt; // time between last and this frame in seconds.
    last_dt = dt;

#if 1
    if (((int)(countLifting(LIFTSTATE_UP, 0.25, 1.0)
	       + 0.5*(float)countLifting(LIFTSTATE_DOWN, 0.0, 1.0)) < (int)(effektProgress(dt,2,3)))
	&& dt > lastlifttime+effektProgress(dt,0.8,0.15) )
      {
	int tolift = (int)(frand()*nstars);
	    
	if (tolift>=0 && tolift<nstars)
	  {
	    if (stars[tolift].lift == LIFTSTATE_BOTTOM)
	      {
		stars[tolift].lift = LIFTSTATE_STARTLIFT;
		stars[tolift].startlift = dt;
		lastlifttime = dt;
	      }
	  }
      }

#endif

    /*--------- Camera Movement -----------*/
#if 0
    if (dt > maxDemoTime)
      {
	static bool manCamMessage = false;
	if (!manCamMessage)
	  {
	    clog << "manual camera activated" << endl;
	    manCamMessage = true;
	  }
	activeCamera = &cam;
	cam.position();
      }
    else
#endif
      {
	const float t2 = effektProgress(dt,0,1.0);
	cam.z = cam_z0 + 70.0*(1.0-cos(t2*t2*M_PI))/2.0;
	cam.roll = dt*dt;
	activeCamera = &cam;
	cam.position();
      }

    backgroundSpinSpeed=dt;
    background->textureRotate=dt*dt*10;
    background->drawSingle();

    light->draw();

    stars[0].star->before();

    /*------ all the stars ----------*/
    for (int i=0; i < nstars; i++)
      {
	//	const float ff = effektProgress(dt, 0, 1);
	const float ff = (dt/maxDemoTime);
	const float floatspeed = ((ff>=1.0)?1.0:(ff*ff*ff*ff*ff))*0.3; // 0..0.3
	const float y = 15.0 * (fmod(floatspeed*dt/2 + (stars[i].y0/(float)rows)+1.0, 2.0) - 1.0) * (rows/6);
	const float x = 15.0 * (stars[i].x0 / 6.0);

	if (stars[i].star)
	  {
	    bool isCenterStar = (stars[i].x0==0 && stars[i].y0==0);

	    glPushMatrix();

	    const float liftincrement = ddt*liftspeed*effektProgress(dt,0.5,2);

	    const float tx = ((x<-1.0)?-1.0:(x>1.0)?1.0:x);
	    const float ty = ((y<-1.0)?-1.0:(y>1.0)?1.0:y);
	    const float maxz = isCenterStar?0:effektProgress(dt,0,cam.z)*0.9 + (cos(tx*M_PI/2.0) * cos(ty*M_PI/2.0)) * effektProgress(dt,1,0.1);

	    if (stars[i].lift == LIFTSTATE_STARTLIFT)
	      {
		stars[i].lift = LIFTSTATE_UP;
		stars[i].maxlift = maxz;
	      }

	    if (stars[i].lift == LIFTSTATE_UP)
	      {
		if (stars[i].z0+liftincrement < stars[i].maxlift)
		  stars[i].z0 += liftincrement;
		else
		  stars[i].lift = LIFTSTATE_DOWN;
	      }
	    else if (stars[i].lift == LIFTSTATE_DOWN)
	      {
		if (stars[i].z0-liftincrement > 0.0)
		  stars[i].z0 -= liftincrement;
		else
		  {
		    stars[i].lift = LIFTSTATE_BOTTOM;
		    stars[i].z0 = 0.0;
		  }
	      }


	    const float z = isCenterStar?0.0:20.0*(sin((stars[i].z0*M_PI - M_PI)/2.0)+1.0)/2.0;


	    glScalef(3.0,3.0,1.0);

	    const float action = (isCenterStar?effektProgress(dt,0,0.7):effektProgress(dt,0.5,1.0));
	    const float ausschlag = starsize*action*4;

	    glTranslatef(x + ausschlag*sin(zitter*dt*stars[i].rand0*1.3*M_PI),
			 -(y + ausschlag*cos(zitter*dt*stars[i].rand0*2.5*M_PI)),
			 z);
	    glRotatef(action*(360.0*sin(dt*stars[i].rand0)), 0.0, 0.0, 1.0);

	    glRotatef(10.0*sin(dt*stars[i].rand0*M_PI*5.0), 1.0, 0.0, 0.0);


	    float scalef = 1;
	    if (!isCenterStar)
	      {
		float bias = effektProgress(dt,0,10);
		if (bias>1.0) bias=1.0;
		scalef = (starsize/4 + (z*liftedSizeFactor) ) * bias * 0.2;
		if (scalef<1.5)
		  scalef=1.5;
	      }
	    glScalef(scalef,scalef,scalef);

	    stars[i].star->draw();
	    glPopMatrix();
	  }
      }
    stars[0].star->after();

    if(flashrun)
      flashrun=flash->draw(time);
  }



};
