#include "camera.h"
#include "camerapath.h"
#include "cube.h"
#include "flash.h"
#include "font.h"
#include "main.h"
#include "scroller.h"

#include "data.h"

#include <sstream>

#include <bezier.hpp>
#include <color.hpp>
#include <gl.hpp>
#include <rand.hpp>
using namespace doj;

extern Font *font1;

namespace Swoosh 
{

  typedef vector<Bezier<fvector, float> > bezier_t;
  bezier_t bezier;
  static const int bezierNum=lowtech?5:8;

  typedef vector<Cube*> cube_t;
  static cube_t cube;
  static const int cubeNum=lowtech?75:100;

  static Cube *solocube=0;

  static Camera cam;
  static CameraPath path;

  static Flash *flashToWhite=0;

  static int starttime=-1;

  static bool initialized=false;

  static int sync=0;
  static int lastSync=-1;
  static float syncScale=0;
  bool syncFlash=false;

  bool scroll=false;

  char nummer=0;

  static const GLenum src[] = {
    GL_ONE,
    GL_ONE,
    GL_SRC_COLOR,
    GL_SRC_ALPHA,
    GL_ONE_MINUS_SRC_ALPHA,
  };
  static const GLenum dst[] = {
    GL_DST_COLOR,
    GL_DST_ALPHA,
    GL_ONE,
    GL_ONE,
    GL_ONE,
  };

  static void deinit()
  {
    for(cube_t::iterator i=cube.begin(); i!=cube.end(); ++i)
      if(*i)
	delete *i;
    if(solocube)
      {
	delete solocube;
	solocube=0;
      }
    if(flashToWhite)
      delete flashToWhite;
  }

  int init()
  {
    int i;

    if(initialized)
      return 0;

    atexit(deinit);

    cube.resize(cubeNum);
    for(i=0; i<cubeNum; i++)
      {
	cube[i]=new Cube("Swoosh::Cube");
	if(cube[i]==NULL)
	  {
	    cerr << "Swoosh::init(): could not alloc cube" << endl;
	    deinit();
	    return -1;
	  }
	hsv h(static_cast<float>(i)*360.0/static_cast<float>(cubeNum), 74.0/256.0, 98.0/256.0);
	rgba r;
	r=h;
	cube[i]->color(r.r, r.g, r.b, .5);
	cube[i]->blendEnable=true;
	cube[i]->zbufferEnable=false;
	if(cube[i]->init() < 0)
	  {
	    cerr << "could not init cube" << endl;
	    deinit();
	    return -1;
	  }
      }

    if(!solocube)
      {
	solocube=new Cube("Swoosh::Cube");
	if(solocube==NULL)
	  {
	    cerr << "Swoosh::init(): could not alloc cube" << endl;
	    deinit();
	    return -1;
	  }
	hsv h(0, 74.0/256.0, 98.0/256.0);
	rgba r;
	r=h;
	solocube->color(r.r, r.g, r.b, .5);
	solocube->blendEnable=true;
	solocube->blendSrc=src[0];
	solocube->blendDst=dst[0];
	solocube->zbufferEnable=false;
	if(solocube->init() < 0)
	  {
	    cerr << "could not init cube" << endl;
	    deinit();
	    return -1;
	  }
	blendObject=solocube;
      }

    bezier.resize(bezierNum);
    for(int j=0; j<bezierNum; j++)
      {
	const float sc=20.0;
	bezier[j].container().push_back(fvector()); // Null Vektor
	for(i=0; i<10; i++)
	  bezier[j].container().push_back(fvector(frand2(), frand2(), frand2())*=sc);
	bezier[j].container().push_back(fvector()); // Null Vektor
	
	bezier[j].init();
      }

    if(!flashToWhite)
      {
	flashToWhite=new Flash("Swoosh::flashToWhite");
	flashToWhite->from(0,0,0,0);
	flashToWhite->to  (1,1,1,1);
	flashToWhite->time(.5);
      }

    cam.z=20;
    std::istringstream s(reinterpret_cast<char*>(&PTHswoosh));
    if(s)
      s >> path;
    else
      {
	cerr << "Swoosh::init(): could not init swoosh.pth stream" << endl;
	deinit();
	return -1;
      }
    path.init();

    if(Scroller::init(0) < 0)
      {
	cerr << "Swoosh::init(): could not init Scroller" << endl;
	deinit();
	return -1;
      }

    initialized=true;    
    return 0;
  }

  void draw(const int time)
  {
    if(!initialized)
      init();

    for(modSync_t::iterator i=modSync.begin(); i!=modSync.end(); /*nothing here*/)
      {
	const int e=*i>>4;
	if(e==3)
	  {
	    const int s=*i&0xf;
	    switch(s)
	      {
	      case 0x9:
	      case 0xa:
	      case 0xb:
	      case 0xc:
		font1->shaded=false;
		nummer=s-9+'1'; 
		break;
	      case 0xd: scroll=true; break;
	      case 0xe: syncFlash=true; break;
	      case 0xf: syncScale=(time-starttime)/1000.0; break;
	      default:
		sync=s;
	      }
	    i=modSync.erase(i);
	  }
	else
	  ++i;
      }

    if((sync==0 && sync!=lastSync) || (starttime==-1))
      {
	starttime=time;
	path.starttime(time);
      }

    if(sync>0 && sync!=lastSync)
      {
	solocube->blendSrc=src[sync-1];
	solocube->blendDst=dst[sync-1];
      }

    const float t=(time-starttime)/1000.0;

    activeCamera=&cam;
#if 0
    cam.position();
#else
    path.position(time);
#endif

    clearColor.r=clearColor.g=clearColor.b=clearColor.a=0;


    float sc=1;
    if(t-syncScale<.5)
      sc+=(1.0-((t-syncScale)*2.0)) * 0.2;

    const float sec=10;
    solocube->before();
    for(int j=0; j<bezierNum; j++)
      for(int i=0; i<cubeNum; i++)
	{
	  float tt=::fmod(static_cast<float>(i)/sec + t/sec, sec);
	  if(sync==0)
	    tt*=t/sec*.75;
 	  
	  fvector v=bezier[j](tt/sec);
	  glPushMatrix();
	  {
	    glTranslate(v);
	    glRotate(v.length(), v);
	    glScalef(sc, sc, sc);
	    if(sync==0)
	      solocube->draw();
	    else
	      cube[i]->draw();
	  }
	  glPopMatrix();
	}
    solocube->after();

    if(syncFlash)
      {
	flashToWhite->before();
	flashToWhite->draw(time);
	flashToWhite->after();
      }

    if(nummer>0)
      {
	font1->before();
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(0,0,-1);
	glScale(2);
	font1->color(0,0,0,1);
	font1->print(nummer, 0, -.3, 0, Font::Center);
	glScale(0.9);
	font1->color(1,1,1,1);
	font1->print(nummer, 0, -.3, 0, Font::Center);
	glPopMatrix();
	font1->after();
      }
    else if(scroll)
      Scroller::draw(time);

    lastSync=sync;
  }

};
