#include "camera.h"
#include "font.h"
#include "main.h"

extern Font *font1;

namespace Title {

  static int starttime=-1;

  static Camera cam;

  static bool fontSet=false;

  static int paint(const Font *font, const string& str, const float t, const float y, int ii=0)
  {
    GLfloat off=-font1->width(str)/2.0;
    const float tmax=10.0;
    for(string::const_iterator i=str.begin(); i!=str.end(); ++i, ++ii)
      {
	float tt=t-ii/2.0;
	if(tt < 0)
	  continue;
	if(tt>tmax)
	  tt=tmax;

	float z=1.0-tt;
	if(z<-1)
	  off+=font1->width(*i);
	else if(z<0)
	  {
	    glPushMatrix();
	    glTranslatef(off, y, 0);
	    glRotatef(z*-120, 0, 1, 0);
	    glScalef(-z+1,-z+1,-z+1);
	    off+=font->print(*i);
	    glPopMatrix();
	  }
	else
	  {
	    glPushMatrix();
	    const float s=z+1.0;
	    glScalef(s,s,s);
	    off+=font->print(*i, off, y, z);
	    glPopMatrix();
	  }
      }
    return ii;
  }

  void draw(const int time)
  {
    if(starttime==-1)
      starttime=time;

    if(font1==NULL)
      return;

    if(!fontSet)
      {
	font1->color(.8,.8,.8,1);
	font1->colorLight=rgba(1,1,1,1);
	font1->colorDark=rgba(.6,.6,.6,1);
	font1->shaded=true;
	fontSet=true;
      }

    const bool zbuf=font1->zbufferEnable;
    font1->zbufferEnable=false;
    glPushMatrix();
    {
      glLoadIdentity();
      cam.position();

      const float t=(time-starttime)/1000.0 *1.2;

      string michael="Michael";
      string dirk=   "und Dirk";

      font1->before();
      int i=paint(font1, michael, t, .25);
      i=paint(font1, dirk, t, -1, i);
      font1->after();
    }
    glPopMatrix();
    font1->zbufferEnable=zbuf;
  }

  int init()
  {
    cam.x=0.0;
    cam.y=0.0;
    cam.z=3;
    cam.roll=0.0;
    cam.pitch=0.0;
    cam.head=0.0;
    cam.fov=90.0;
    cam.nearClip=1;
    cam.farClip=100;
    starttime=-1;
    fontSet=false;
    return 0;
  }

};
